<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudTasks;

class RateLimits extends \Google\Model
{
  /**
   * @var int
   */
  public $maxBurstSize;
  /**
   * @var int
   */
  public $maxConcurrentDispatches;
  public $maxDispatchesPerSecond;

  /**
   * @param int
   */
  public function setMaxBurstSize($maxBurstSize)
  {
    $this->maxBurstSize = $maxBurstSize;
  }
  /**
   * @return int
   */
  public function getMaxBurstSize()
  {
    return $this->maxBurstSize;
  }
  /**
   * @param int
   */
  public function setMaxConcurrentDispatches($maxConcurrentDispatches)
  {
    $this->maxConcurrentDispatches = $maxConcurrentDispatches;
  }
  /**
   * @return int
   */
  public function getMaxConcurrentDispatches()
  {
    return $this->maxConcurrentDispatches;
  }
  public function setMaxDispatchesPerSecond($maxDispatchesPerSecond)
  {
    $this->maxDispatchesPerSecond = $maxDispatchesPerSecond;
  }
  public function getMaxDispatchesPerSecond()
  {
    return $this->maxDispatchesPerSecond;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RateLimits::class, 'Google_Service_CloudTasks_RateLimits');
